library(dplyr)
source(file.path(iPath, "Independence_FunctionNCDC.R"))
All_Freq <- NULL

NCDC_Analysis <- function(Data, Start, End, Lag1, Lag2){
  NCDC <- fread(file.path(iPath_Out_NCDC, Data))
  
  NCDC$CZ_FIPS[nchar(NCDC$CZ_FIPS)==1] <- paste0("00", NCDC$CZ_FIPS[nchar(NCDC$CZ_FIPS)==1])
  NCDC$CZ_FIPS[nchar(NCDC$CZ_FIPS)==2] <- paste0("0", NCDC$CZ_FIPS[nchar(NCDC$CZ_FIPS)==2])
  
  State <- unique(NCDC$STATE_FIPS)
  
  Counter <- 0 
  for (i in 1:length(State)){
    #Need to filter by state
    Temp_ST <- NCDC[STATE_FIPS == State[i]]

    County <- unique(Temp_ST$CZ_FIPS)
    
    for(j in 1:length(County)){
      
      Temp_CZ <- Temp_ST[CZ_FIPS == County[j]] #allows for all values in the array to be filtered
      
      #Create the Begin and End Date from the Split Data
      Temp_CZ$Begin_Date <- as.Date(paste(Temp_CZ$BEGIN_YEAR, Temp_CZ$BEGIN_MONTH, Temp_CZ$BEGIN_DAY, sep = "."), format = "%Y.%m.%d")
      Temp_CZ$End_Date <- as.Date(paste(Temp_CZ$END_YEAR, Temp_CZ$END_MONTH, Temp_CZ$END_DAY, sep = "."), format = "%Y.%m.%d")
      
      #Ordering the data properly for an analysis
      Temp_CZ <- Temp_CZ[order(Temp_CZ$Begin_Date, Temp_CZ$End_Date),]
      
      #Subset the data based on a start and end date
      Temp_CZ <- subset(Temp_CZ, Begin_Date >= Start)
      Temp_CZ <- subset(Temp_CZ, End_Date <= End)
      
      df <- data.frame(Begin_Date = Temp_CZ$Begin_Date,End_Date = Temp_CZ$End_Date) 
      df$mid <- df$Begin_Date + floor((df$End_Date-df$Begin_Date)/2)
      
      Temp_CZ$Peak_Date <- df$mid
      
      for (k in 1:(nrow(Temp_CZ))){
        Temp_CZ$Begin_Date[k] <- Temp_CZ$Begin_Date[k] - Lag1
        Temp_CZ$End_Date[k] <- Temp_CZ$End_Date[k] + Lag2
        # Temp_CZ$Begin_Date[k] <- Temp_CZ$Peak_Date[k] - Lag1
        # Temp_CZ$End_Date[k] <- Temp_CZ$Peak_Date[k] + Lag2
      }
    
      Events <- Independence_NCDC(Temp_CZ)
    
      Frequency <- sum(nrow(Events))
      All_Freq <- rbind(All_Freq, data.frame(State = State[i], County = County[j], Frequency = Frequency))
    }
    Counter <- Counter + 1 
    print(Counter)
  }
  
  return(All_Freq)
  
}
